﻿#include  "StdAfx.h"

#include  "FolderEnumIDList.hpp"
#include  "Pidl.hpp"
#include  <szStoredItem.hpp>
#include  <szPath.hpp>

using namespace szpp;

CFolderEnumIDList::CFolderEnumIDList() : m_enumFolders(false), m_enumFiles(false), m_CurrentItem(0), m_NumberOfItems(0), m_Container(0)
{
}

CFolderEnumIDList::~CFolderEnumIDList()
{
}

void CFolderEnumIDList::Configure(bool enumFolders, bool enumFiles, szpp::StoredItemContainer *container)
{
  m_enumFolders = enumFolders;
  m_enumFiles = enumFiles;

  m_Container = container;

  m_NumberOfItems = 0;
  if (m_enumFolders)
    m_NumberOfItems += static_cast<u32>(m_Container->GetNumberOfSubContainers());
  if (m_enumFiles)
    m_NumberOfItems += static_cast<u32>(m_Container->GetNumberOfSubItems());
}

// IEnumIDList::Next
STDMETHODIMP CFolderEnumIDList::Next(ULONG celt, PITEMID_CHILD *rgelt, ULONG *pceltFetched)
{
  u32 remaining = m_NumberOfItems - m_CurrentItem;
  u32 count = min(celt, remaining);
  u32 folders = m_enumFolders ? static_cast<u32>(m_Container->GetNumberOfSubContainers()) : 0;

  for (u32 i = 0; i < count; ++i)
  {
    u32 pos = i + m_CurrentItem;
    rgelt[i] = NameToPidl(ExtractFileName(
      pos < folders ? // 現在のポジションがフォルダ数よりも小さい？（→フォルダの情報をコピーすることを意味する）
      m_Container->GetSubContainer(pos)->GetName() :       // フォルダ
      m_Container->GetSubItem(pos - folders)->GetName())); // ファイル
  }
  m_CurrentItem += count;
  if (pceltFetched != 0)
    *pceltFetched = count;
  return (count < celt) ? S_FALSE : S_OK;
}

// IEnumIDList::Skip
STDMETHODIMP CFolderEnumIDList::Skip(DWORD celt)
{
  u32 remaining = m_NumberOfItems - m_CurrentItem;
  u32 count = min(celt, remaining);
  m_CurrentItem += count;
  return S_OK;
}

// IEnumIDList::Reset
STDMETHODIMP CFolderEnumIDList::Reset()
{
  m_CurrentItem = 0;
  return S_OK;
}

// IEnumIDList::Clone
STDMETHODIMP CFolderEnumIDList::Clone(IEnumIDList **ppenum)
{
  if (0 == ppenum)
    return E_POINTER;

  *ppenum = 0;

  CComObject<CFolderEnumIDList> *penum;
  HRESULT hr = CComObject<CFolderEnumIDList>::CreateInstance(&penum);
  if (FAILED(hr))
    return hr;

  penum->AddRef();

  penum->m_enumFolders = m_enumFolders;
  penum->m_enumFiles = m_enumFiles;
  penum->m_Container = m_Container;
  penum->m_NumberOfItems = m_NumberOfItems;
  penum->m_CurrentItem = m_CurrentItem;

  hr = penum->QueryInterface(IID_IEnumIDList, (void **)ppenum);

  penum->Release();

  return hr;
}
